#include <iostream>
#include <map>

struct AxisCount { int even = 0; int odd = 0; };

int main() {
	int count;
	std::cin >> count;
	std::map<int, int> hashmap1;
	std::map<int, int> hashmap2;
	std::map<int, AxisCount> hashmapX;
	std::map<int, AxisCount> hashmapY;

	for (int i = 0; i < count; i++) {
		int x, y;
		std::cin >> x >> y;
		hashmap1[x - y]++;
		hashmap1[x + y]++;
		if (y % 2) hashmapX[x].odd++;
		else hashmapX[x].even++;
		if (x % 2) hashmapY[y].odd++;
		else hashmapY[y].even++;
	}

	int greetings = 0;

	for (std::pair<int, int> x : hashmap1)
		greetings += x.second * (x.second - 1);
	for (std::pair<int, int> x : hashmap2)
		greetings += x.second * (x.second - 1);
	for (std::pair<int, AxisCount> x : hashmapX)
		greetings += (x.second.odd * (x.second.odd - 1) + x.second.even * (x.second.even)) / 2;
	for (std::pair<int, AxisCount> x : hashmapY)
		greetings += (x.second.odd * (x.second.odd - 1) + x.second.even * (x.second.even)) / 2;

	std::cout << greetings;
}